;(function ($) {
    "use strict";

    var sdAddressValidator = {
        response: {
            status: 1,
            title: null,
            message: null,
            components: null,
            multiple: false,
            validations: null
        },

        data: {
            url: null,
            form: null,
            modal: {
                container: '[data-sd-va-modal]',
                title: '[data-sd-va-modal-title]',
                body: '[data-sd-va-modal-body]',
                footer: '[data-sd-va-modal-footer]',
                submit: '[data-sd-va-submitform]',
            },
            allowSubmit: false,
            formsParams: ['[name="editRechnungsadresse"]', '[name="lieferdaten"]']
        },
        init: function () {
            var that = this;
            this.data.url = sdAVAjax;
            $('[data-sd-ajax-url]').remove();
            $(document).on('submit', 'form', function ($e) {
                that.data.form = $($e.target);
                if ($($e.target).find(that.data.formsParams.join(',')).length > 0 && !that.data.allowSubmit) {
                    $e.stopPropagation();
                    // $e.preventDefault();
                    that.showLoader();
                    var formData = new FormData(that.data.form[0]);
                    $.ajax({
                        url: that.data.url,
                        type: "POST",
                        data: formData,
                        processData: false,
                        contentType: false,
                        dataType: "json",
                        success: function (response) {
                            that.response = response;
                            if (response.multiple) {
                                that.multipleSuccessResponse(0);
                            } else {
                                that.singleSuccessResponse();
                            }
                            return that.hideLoader();
                        },
                        error: function () {
                            that.callError();
                            return that.hideLoader();
                        }
                    });
                    return false;
                }
            });
        },

        multipleSuccessResponse: function (i) {
            i = typeof i === 'undefined' ? 0 : i;
            var last = i >= this.response.validations.length;
            if (last) {
                this.submitForm();
                return true;
            }
            var form = this.response.validations[i];
            switch (parseInt(form.status)) {
                case 1:
                    last ? this.submitForm() : this.multipleSuccessResponse(i + 1);
                    break;
                case 2:
                    last ? this.multipleSuccessResponse(i + 1) : this.checkAddressModal(form);
                    break;
                case 3:
                    this.selectAddressMultipleModal(form, i);
                    break
            }

        },

        singleSuccessResponse: function () {
            switch (parseInt(this.response.status)) {
                case 1:
                    this.submitForm();
                    break;
                case 2:
                    this.checkAddressModal(this.response);
                    break;
                case 3:
                    this.selectAddressSingleModal();
                    break;
            }
        },

        callError: function () {
            this.submitForm();
        },

        setCorrectData: function (data) {
            var i, that = this;
            for (i in data) {
                if (i === 'formated') {
                    continue;
                }
                $(this.data.form).find('[name="' + i + '"]').val(data[i]);
                $(this.data.form).find('[name="' + i + '"]').on('keyup', function () {
                    that.data.allowSubmit = false;
                })
            }

        },

        submitForm: function () {
            var that = this;
            this.data.allowSubmit = true;
            this.showLoader();
            setTimeout(function () {
                that.data.form.submit();
            }, 500);
        },

        checkAddressModal: function (data) {
            var that = this;
            $(this.data.modal.footer).show();
            $(this.data.modal.title).html(data.title);
            $(this.data.modal.body).html(data.message);
            $(this.data.modal.container).modal();
            $(document).on('click', this.data.modal.submit, function () {
                $(that.data.modal.container).modal('hide');
                that.submitForm();
            })
        },

        selectAddressSingleModal: function () {
            var that = this, i, listGroup = $('<div/>').addClass('.list-group'), listItem;
            $(this.data.modal.footer).hide();
            $(this.data.modal.title).html(this.response.title);
            $(this.data.modal.body).html(this.response.message);
            for (i in this.response.components) {
                var component = this.response.components[i];
                listItem = $('<a/>')
                    .addClass('list-group-item')
                    .attr('href', 'javascript:void(0)')
                    .attr('data-sd-va-address-component', JSON.stringify(component))
                    .html(component.formated);
                listGroup.append(listItem);
            }
            $(this.data.modal.body).append(listGroup);

            $(document).on('click', '[data-sd-va-address-component]', function (event) {
                event.preventDefault();
                var data = $(event.target).data('sd-va-address-component');
                if (typeof data.is_correct === 'undefined' || parseInt(data.is_correct) !== 1) {
                    that.setCorrectData(data);
                }
                $(that.data.modal.container).modal('hide');
                return that.submitForm();
            });
            $(this.data.modal.container).modal('show');
        },

        selectAddressMultipleModal: function (data, modalIndex) {
            var that = this, i, listGroup = $('<div/>').addClass('.list-group'), listItem;
            $(this.data.modal.footer).hide();
            $(this.data.modal.title).html(data.title);
            $(this.data.modal.body).html(data.message);
            for (i in data.components) {
                var component = data.components[i];
                listItem = $('<a/>')
                    .addClass('list-group-item')
                    .attr('href', 'javascript:void(0)')
                    .attr('data-sd-va-address-component', JSON.stringify(component))
                    .text(component.formated);
                listGroup.append(listItem);
            }
            $(this.data.modal.body).append(listGroup);
            $(this.data.modal.container).modal('show');

            $(document).on('click', '[data-sd-va-address-component]', function (event) {
                event.preventDefault();
                var data = $(event.target).data('sd-va-address-component');
                that.setCorrectData(data);
                $(that.data.modal.container).modal('hide');
                that.multipleSuccessResponse(modalIndex + 1);
            });
        },

        showLoader: function () {
            var loaderContainer = $('<div/>');
            loaderContainer.attr('data-sd-av-loader', ' ');
            loaderContainer.css({
                position: 'absolute',
                left: 0,
                top: 0,
                bottom: 0,
                right: 0,
                background: 'rgba(255,255,255,0.5)',
                zIndex: 8000
            });

            var spinner = $('<div/>').css({
                border: '8px solid #aaa', /* Light grey */
                borderTop: '8px solid #333', /* Blue */
                borderRadius: '50%',
                width: '60px',
                height: '60px',
                position: 'absolute',
                top: '50%',
                left: '50%',
                transform: 'translate(-50%, -50%)',
                animation: 'spin 2s linear infinite'
            });
            loaderContainer.html(spinner);
            $(this.data.form).css('position', 'relative');
            $(this.data.form).append(loaderContainer);
        },

        hideLoader: function () {
            $('[data-sd-av-loader]').remove();
        },

        prepareRequest: function (data) {
            var $request = {}, i;
            for (i = 0; i < data.length; i++) {
                $request[data[i].name] = data[i].value;
            }
            return JSON.stringify($request);
        }
    };
    window.addEventListener('load', function () {
        sdAddressValidator.init();
    });
})(jQuery);
