document.addEventListener("DOMContentLoaded", function (event) {
    $('#sd-bonuspunkte-plugin').DataTable({
        columns: [
            null,
            null,
            null,
            null,
            null,
            {"orderable": false}
        ],
        language: {
            "sEmptyTable":      "Keine Daten in der Tabelle vorhanden",
            "sInfo":            "_START_ bis _END_ von _TOTAL_ Eintrgen",
            "sInfoEmpty":       "0 bis 0 von 0 Eintrgen",
            "sInfoFiltered":    "(gefiltert von _MAX_ Eintrgen)",
            "sInfoPostFix":     "",
            "sInfoThousands":   ".",
            "sLengthMenu":      "_MENU_ Eintrge anzeigen",
            "sLoadingRecords":  "Wird geladen...",
            "sProcessing":      "Bitte warten...",
            "sSearch":          "Suchen",
            "sZeroRecords":     "Keine Eintrge vorhanden.",
            "oPaginate": {
                "sFirst":       "Erste",
                "sPrevious":    "Zurck",
                "sNext":        "Nchste",
                "sLast":        "Letzte"
            },
            "oAria": {
                "sSortAscending":  ": aktivieren, um Spalte aufsteigend zu sortieren",
                "sSortDescending": ": aktivieren, um Spalte absteigend zu sortieren"
            },
            select: {
                rows: {
                    _: '%d Zeilen ausgewhlt',
                    0: 'Zum Auswhlen auf eine Zeile klicken',
                    1: '1 Zeile ausgewhlt'
                }
            }
        }
    });

    $('.modal-ajax').on('click', function (event) {
        event.preventDefault();
        $('#modal').modal();
    });

    $('.settings').on('click', '.add-bonus', function (event) {
        event.preventDefault();
        let email = $(this).closest('tr').find('.email').html();
        let name = $(this).closest('tr').find('.name').html();
        let id = $(this).closest('tr').data('id');
        $('#modal-add .modal-title .user').html(name + '(' + email + ')');
        $('#modal-add input[name="bonus_id"]').val(id);
        $('#modal-add').modal();
    });

    $('.settings').on('click', '.remove-bonus', function (event) {
        event.preventDefault();
        let email = $(this).closest('tr').find('.email').html();
        let name = $(this).closest('tr').find('.name').html();
        let id = $(this).closest('tr').data('id');
        let sum = $(this).closest('tr').data('sum');
        $('#modal-remove .modal-title .user').html(name + '(' + email + ')');
        $('#modal-remove input[name="bonus_id"]').val(id);
        $('#modal-remove input[name="bonus_value"]').attr('max', sum);
        $('#modal-remove').modal();
    });

    $('.settings-content').on('change', '#rate', function () {
        $('#bonus-rate-label').html($(this).val());
    });
});