import Vue from 'vue'
import Vuex from 'vuex'
import axios from './../axios'

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
  },
  mutations: {
    set(state, data) {
      let i;
      for (i in data) {
        state[i] = data[i] === null ? null : Object.assign({}, data[i]);
      }
    },},
  actions: {
    request: (context, request) => {
      return new Promise((resolve, reject) => {
        const token = document.head.querySelector('meta[name=access-token]').content;
        axios({
          method: 'post',
          url: window.location.href,
          data: Object.assign(request, { token }) || { token }
        }).then(res => {
          return resolve(res.data)
        }).catch(err => {
          return reject(err)
        });
      })
    }
  },
  modules: {}
})
