import axios from "axios";
import store from './../store';
import router from './../router';

import https from 'https'

const axiosInstance = axios.create({
  baseURL: window.location.href,
  headers: {},
  httpsAgent: new https.Agent({
    rejectUnauthorized: false
  })
});
axiosInstance.interceptors.request.use(config => {
  NProgress.start();
  return config;
}, error => {
  NProgress.done();
  return Promise.reject(error);
});
axiosInstance.interceptors.response.use(res => {
  NProgress.done();
  return res;
}, error => {
  NProgress.done();
  return Promise.reject(error);
});

export default axiosInstance
