const NProgress = require('nprogress'), _ = require('lodash');

window.NProgress = NProgress;
window._ = _;
import Vue from 'vue'
import App from './App.vue'
import store from './store'
import axios from './axios'
import VueNotification from "@kugatsu/vuenotification";
import 'nprogress/nprogress.css'
import VueI18n from 'vue-i18n'

NProgress.configure({ showSpinner: false });
Vue.use(VueI18n);
Vue.use(VueNotification, {
  timer: 7,
  showCloseIcn: true,
  position: 'bottomRight'
});
// Vue.use(VeeValidate);
Vue.config.productionTip = false;

const i18n = new VueI18n({
  locale: 'de',
})

Vue.prototype.$axios = axios;
Vue.prototype.$shopToken = document.head.querySelector('meta[name=access-token]').content;

document.addEventListener('DOMContentLoaded', () => {
  new Vue({
    store,
    i18n,
    render: function(h) {
      return h(App)
    }
  }).$mount('#vue')
}, false)
