{if isset($smarty.get.fillOut) && $smarty.get.fillOut=='bonuses_insufficient_message'}
    <div class="alert alert-info bonuses-info">
        {$sdDigitalTranslations.digitalMoneyUnsufficient}
    </div>
{/if}

{if $smarty.session.Kunde->sdDigitalMoneyCount > 0 && ($smarty.session.Kunde->sdDigitalMoneyMinimal == 0 || ($smarty.session.Kunde->sdDigitalMoneyMinimal <= $smarty.session.Kunde->sdDigitalMoneyCount))}
    <form id="basket-credit-form" method="post" action="{$sdDigitalMoneyUrl}">
        {block name="basket-digital-money"}
            <div id="digital-money" class="panel panel-default">
                <div class="panel-heading">
                    <h4 class="panel-title">{$sdDigitalTranslations.digitalMoneyUseDigitalMoney}</h4>
                </div>
                <div class="panel-body">
                    <fieldset>
                        <div class="row">
                            <div class="col-lg-6 col-xs-12">
                                <p class="alert alert-info credit-amount-description text-center">
                                    {$sdDigitalTranslations.digitalMoneyBasketTitle}
                                    <strong class="credit-amount">{$smarty.session.Kunde->sdDigitalMoneyCount|number_format:2:",":"."}</strong>
                                    {$sdDigitalTranslations.digitalMoneyFor}
                                    <strong class="credit-amount">{$smarty.session.Kunde->sdDigitalMoney}</strong>
                                </p>
                                {if isset($smarty.session.Kunde->sdExpiredBonusesList) }

                                    {foreach from=$smarty.session.Kunde->sdExpiredBonusesList item=value}
                                        {if $value->expiredAt}
                                            {$sdDigitalTranslations.expiredBonusMessage|printf:{$value->nGuthaben|number_format:2:",":"."}:"":{substr($value->expiredAt,0,10)|date_format:"%d.%m.%Y"}|substr:0:-2}
                                            <br>
                                        {/if}
                                    {/foreach}

                                {/if}
                            </div>
                            <div class="col-lg-6 col-xs-12">
                                <div class="row">
                                    <div class="col-md-6 col-xs-12 alert">
                                        <p> {$sdDigitalTranslations.digitalMoneyBasketDesc}</p>
                                    </div>
                                    <div class="col-md-6 col-xs-12 form-group top10">
                                        <span class="input-group">
                                            <input type="number" class="form-control" name="bonus-count" min="0.01"
                                                   max="{$smarty.session.Kunde->sdDigitalMoneyCount}"
                                                   step="0.01"
                                                   value="{$smarty.session.Kunde->sdDigitalMoneyCount}"/>
                                            <span class="input-group-btn">
                                                 {$jtl_token}
                                                <input type="hidden" name="applyDigitalMoney" value="1"/>
                                                <input type="submit" id="sd-apply-bonusguthaben" name="submit"
                                                       value="{$sdDigitalTranslations.digitalMoneyButtonText}"
                                                       data-action="{$sdDigitalMoneyUrl}"
                                                       class="btn btn-default">
                                            </span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
        {/block}
    </form>
{/if}
