var map, marker, geocoder, addressModified = false, initialLocation;

var browserSupportFlag = new Boolean();
function initMap() {


    var mapOptions = {
        zoom: 1,
        disableDefaultUI: true,
        zoomControl: true,
        mapTypeControl: true,
        zoomControlOptions: {
            style: google.maps.ZoomControlStyle.SMALL
        }
    };

    map = new google.maps.Map(document.getElementById("g-map"), mapOptions);

    // Try W3C Geolocation (Preferred)
    if (navigator.geolocation) {
        browserSupportFlag = true;
        navigator.geolocation.getCurrentPosition(function (position) {
            initialLocation = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
            // marker = new google.maps.Marker({position: initialLocation});
            placeMarker(initialLocation);
            //map.setCenter(initialLocation);
        }, function () {
            handleNoGeolocation(browserSupportFlag);
        });
    }
    // Browser doesn't support Geolocation
    else {
        browserSupportFlag = false;
        handleNoGeolocation(browserSupportFlag);
    }

    function handleNoGeolocation(errorFlag) {
        if (errorFlag == true) {
            alert("Geolocation service failed.");
            initialLocation = newyork;
        } else {
            alert("Your browser doesn't support geolocation. We've placed you in Siberia.");
            initialLocation = siberia;
        }
        map.setCenter(initialLocation);
    }

    google.maps.event.addListener(map, 'click', function (event) {
        placeMarker(event.latLng);
    });

    geocoder = new google.maps.Geocoder();
    var input = /** @type {!HTMLInputElement} */(
        document.getElementById('pac-input'));

    map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

    var autocomplete = new google.maps.places.Autocomplete(input);
    autocomplete.bindTo('bounds', map);

    var infowindow = new google.maps.InfoWindow();
    marker = new google.maps.Marker({
        //position: location,
        map: map,
        draggable: true,
        animation: google.maps.Animation.DROP,
    });
    autocomplete.addListener('place_changed', function () {

        infowindow.close();
        marker.setVisible(false);
        var place = autocomplete.getPlace();
        if (!place.geometry) {
            window.alert("Autocomplete's returned place contains no geometry");
            return;
        }

        // If the place has a geometry, then present it on a map.
        if (place.geometry.viewport) {
            map.fitBounds(place.geometry.viewport);
        } else {
            map.setCenter(place.geometry.location);
            map.setZoom(17);  // Why 17? Because it looks good.
        }
        marker.setPosition(place.geometry.location);
        updateCoordinates(place.geometry.location);
        marker.setVisible(true);

        var address = '';
        if (place.address_components) {
            address = [
                (place.address_components[0] && place.address_components[0].short_name || ''),
                (place.address_components[1] && place.address_components[1].short_name || ''),
                (place.address_components[2] && place.address_components[2].short_name || '')
            ].join(' ');
        }

        //infowindow.setContent('<div><strong>' + place.name + '</strong><br>' + address);
        //infowindow.open(map, marker);
    });

    // Sets a listener on a radio button to change the filter type on Places
    // Autocomplete.
    function setupClickListener(id, types) {
        var radioButton = document.getElementById(id);
        radioButton.addEventListener('click', function () {
            autocomplete.setTypes(types);
        });
    }

    setupClickListener('changetype-all', []);
    //setupClickListener('changetype-address', ['address']);
    //setupClickListener('changetype-establishment', ['establishment']);
    //setupClickListener('changetype-geocode', ['geocode']);

    //getLocation();
    if (($('#lat').val() == "" || $('#lng').val() == "") && $('#shop-address').val() != "") {

        geocoder.geocode({'address': $('#shop-address').val()}, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                map.setCenter(results[0].geometry.location);
                map.setZoom(10);
            }
        });

    }
    updateMarker();

    google.maps.event.addListener(marker, 'dragend', function (e) {
        updateCoordinates(e.latLng);
    });

    $('#lat').change(function () {
        updateMarker();
    });
    $('#lng').change(function () {
        updateMarker();
    });
    if ($('#shop-address').val() == "") {
        $('#shop-address').keypress(function () {
            addressModified = true;
        });
    }
}
function placeMarker(location) {
    if (marker.getPosition() != undefined) return false;
    updateCoordinates(location);
    if (map.getZoom() < 11 /*&& empty(marker.getPosition())*/) {
        map.setZoom(11);
        map.setCenter(location);
    }
    marker.setPosition(location);


}
function updateCoordinates(location) {
    $('#lat').val(location.lat());
    $('#lng').val(location.lng());
    if (!addressModified) {
        geocoder.geocode({'latLng': location}, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                $('#shop-address').val(results[0].formatted_address);
            }
        });
    }
}
function updateMarker() {
    if ($('#lat').val() == "" || $('#lng').val() == "") return false;
    var location = new google.maps.LatLng($('#lat').val(), $('#lng').val());
    marker.setPosition(location);
    map.setCenter(location);
    map.setZoom(16);
}
function getLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(showPosition);
    } else {
        alert("Geolocation is not supported by this browser.");
    }
}