//<![CDATA[
var map;
var markers = [];
var infoWindow;
var position;
var labels = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
var days = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];

var sdStoreLocator = {
    init: function () {
        $(document).ready(function () {
            sdStoreLocator.blocksManipulations();
        });
        $(window).resize(function () {
            sdStoreLocator.blocksManipulations();
        });
        map = new google.maps.Map(document.getElementById("g-map"), {
            zoom: 4,
            mapTypeId: 'roadmap'
        });
        
        sdStoreLocator.geoLocation();
        infoWindow = new google.maps.InfoWindow();
        sdStoreLocator.searchStores(true);
        var input = /** @type {!HTMLInputElement} */(
            document.getElementById('sd-enter-address'));
        var autocomplete = new google.maps.places.Autocomplete(input);
        autocomplete.bindTo('bounds', map);
        autocomplete.addListener('place_changed', function () {
            sdStoreLocator.searchFromInput(autocomplete)
        });
        $("#sd-search-store").on('click', function () {
            sdStoreLocator.searchFromInput(autocomplete)
        });
    },
    searchFromInput: function (autocomplete) {
        infoWindow.close();
        $("#sd-sl-search").find("button#sd-search-store>i").removeAttr("class").addClass("fa fa-circle-o-notch fa-spin fa-fw");
        var place = autocomplete.getPlace();
        if (!place.geometry) {
            window.alert("Autocomplete's returned place contains no geometry");
            return;
        }
        if (place.geometry.viewport) {
            map.fitBounds(place.geometry.viewport);
        } else {
            map.setCenter(place.geometry.location);
            map.setZoom(12);  // Why 17? Because it looks good.
        }
        var address = '';
        if (place.address_components) {
            address = [
                (place.address_components[0] && place.address_components[0].short_name || ''),
                (place.address_components[1] && place.address_components[1].short_name || ''),
                (place.address_components[2] && place.address_components[2].short_name || '')
            ].join(' ');
        }
        sdStoreLocator.searchLocations(place.geometry.location, false, 20);
    },
    geoLocation: function () {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                map.setCenter(new google.maps.LatLng(position.coords.latitude, position.coords.longitude));
            }, function () {
                $("#sd-search-near").remove();
                sdStoreLocator.noGeoLocation();
            });
        }
        else {
            sdStoreLocator.noGeoLocation();
        }
    },
    noGeoLocation: function () {
        $(".sd-store-list").find("i").remove("i");
        var geocoder = new google.maps.Geocoder();
        geocoder.geocode({'address': sd_store_locator.address}, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                map.setCenter(results[0].geometry.location);
                map.fitBounds(results[0].geometry.viewport);
                sdStoreLocator.searchLocations(results[0].geometry.location, true);
            }
            else {
                position = new google.maps.LatLng(sd_store_locator.defLat, sd_store_locator.defLng);

                sdStoreLocator.searchLocations(position, true);
                map.setCenter(position);
                map.setZoom(6)
            }
        });
    },
    searchStores: function (searchAll) {
        searchAll = typeof searchAll !== 'undefined' ? searchAll : false;
        var geocoder = new google.maps.Geocoder();
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                geocoder.geocode({location: new google.maps.LatLng(position.coords.latitude, position.coords.longitude)}, function (results, status) {
                    if (status == google.maps.GeocoderStatus.OK) {
                        sdStoreLocator.searchLocations(results[0].geometry.location, searchAll);
                    } else {
                        alert(address + ' not found');
                    }
                });
            }, function () {
                sdStoreLocator.noGeoLocation();

            });
        }
        // Browser doesn't support Geolocation
        else {
            sdStoreLocator.noGeoLocation();
        }
    },
    searchLocations: function (center, searchAll, radius) {
        searchAll = typeof searchAll !== 'undefined' ? searchAll : false;
        var searchUrl, data;
        data = {
            lat: center.lat(),
            lng: center.lng(),
            measure: sd_store_locator.measure,
            language: sd_store_locator.lang
        };
        if (!searchAll) {
            var defaultRadius = 5;
            data["radius"] = typeof radius !== 'undefined' ? radius : defaultRadius;
        }
        $.ajax({
            url: sd_store_locator.url + 'sd-store-locator.php',
            data: data,
            type: "POST",
            success: function (result, status, xhr) {
                var json = JSON.parse(xhr.responseText);
                if (typeof json.log != 'undefined') {
                    console.log(json.log);
                }
                if (typeof json.error != 'undefined') {
                    $(".sd-store-list").html("<p class='alert alert-warning'>" + json.error + "</p>");
                    $("#sd-sl-search").find("button.btn-primary>i").removeAttr("class").addClass("fa fa-search");
                }
                else {
                    var bounds = new google.maps.LatLngBounds();
                    var stores = json.stores;
                    sdStoreLocator.clearLocations();
                    for (var i = 0; i < stores.length; i++) {
                        var ShopName = stores[i].ShopName;
                        var ShopAddress = stores[i].ShopAddress;
                        var distance = stores[i].distance;
                        var
                            latlng = new google.maps.LatLng(
                                parseFloat(stores[i].Lat), parseFloat(stores[i].Lng));
                        sdStoreLocator.createOption(ShopName, ShopAddress, distance, i, json.translation);
                        sdStoreLocator.createMarker(latlng, stores[i], json.translation, i);
                        bounds.extend(latlng);

                    }
                    map.fitBounds(bounds);

                    $("#sd-sl-search").find("button.btn-primary>i").removeAttr("class").addClass("fa fa-search");
                    $(".location-item").on("click", function (event) {
                        event.preventDefault();
                        var markerNum = parseInt($(this).attr("data-id"), 10);
                        if (markerNum != "none") {
                            new google.maps.event.trigger(markers[markerNum], 'click');
                            var currCenter = map.getCenter();
                            map.setZoom(16);
                            google.maps.event.trigger(map, 'resize');
                            map.setCenter(currCenter);
                        }
                    });

                    if (stores.length < 5)
                        map.setZoom(12);
                }
            },
            error: function (xhr, status, error) {
                var s = status;
            }
        });
    },
    clearLocations: function () {
        infoWindow.close();
        $(".sd-store-list").find(".list-group").html("");
        for (var i = 0; i < markers.length; i++) {
            markers[i].setMap(null);
        }
        markers.length = 0;
    },
    getLabel: function (num) {
        var l = [], c, n = num;
        do {
            c = Math.floor(n / labels.length);
            if (c > 0) {
                l.push(labels[c - 1]);
                n = n - (labels.length * c);
            }
            else {
                l.push(labels[n]);
                n = -1;
            }
        }
        while (n >= 0);
        return l.join("");
    },
    getIcon: function (label) {
        /*
         return 'data:image/svg+xml,' +
         '%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20version%3D%221.0%22%20id%3D%22Layer_1%22%20x%3D%220px%22%20y%3D%220px%22%20width%3D%2264px%22%20height%3D%2264px%22%20viewBox%3D%220%200%202481%202073%22%20enable-background%3D%22new%200%200%202481%202073%22%20xml%3Aspace%3D%22preserve%22%3E%0A%09%3Cpath%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%20fill%3D%22%23E81E25%22%20stroke%3D%22%23000000%22%20stroke-width%3D%2237%22%20stroke-miterlimit%3D%2210%22%20d%3D%22%20%20%20M730.94%2C1839.629c-38.766-190.301-107.116-348.665-189.903-495.44c-61.407-108.872-132.544-209.363-198.364-314.938%20%20%20c-21.972-35.244-40.934-72.477-62.047-109.054c-42.216-73.137-76.444-157.935-74.269-267.932%20%20%20c2.125-107.473%2C33.208-193.684%2C78.03-264.172c73.719-115.935%2C197.201-210.989%2C362.884-235.969%20%20%20c135.466-20.424%2C262.475%2C14.082%2C352.543%2C66.748c73.6%2C43.038%2C130.596%2C100.527%2C173.92%2C168.28%20%20%20c45.22%2C70.716%2C76.359%2C154.26%2C78.971%2C263.232c1.337%2C55.83-7.805%2C107.532-20.684%2C150.418%20%20%20c-13.034%2C43.409-33.996%2C79.695-52.646%2C118.454c-36.406%2C75.659-82.049%2C144.982-127.855%2C214.346%20%20%20C915.083%2C1340.208%2C787.024%2C1550.912%2C730.94%2C1839.629z%22%2F%3E%0A%09%3Cpath%20opacity%3D%220.09%22%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%20d%3D%22M731.379%2C1934.407%20%20%20c131.604-120.864%2C211.314-235.977%2C269.138-350.49c42.892-84.942%2C70.542-169.166%2C106.953-254.061%20%20%20c12.156-28.34%2C28.508-56.568%2C42.519-85.3c28.018-57.449%2C72.657-118.133%2C169.03-178.096c94.16-58.588%2C193.955-93.756%2C291.58-114.697%20%20%20c160.565-34.442%2C344.277-37.299%2C502.593%2C15.593c129.444%2C43.246%2C204.674%2C113.469%2C233.778%2C178.863%20%20%20c23.783%2C53.438%2C21.428%2C108.185-1.045%2C163.103c-23.455%2C57.32-69.568%2C116.065-161.105%2C177.391%20%20%20c-46.898%2C31.417-98.9%2C56.333-146.412%2C74.868c-48.088%2C18.761-96.6%2C30.392-145.328%2C44.32%20%20%20c-95.119%2C27.188-192.42%2C47.153-289.891%2C67.076C1312.866%2C1732.316%2C1025.938%2C1797.298%2C731.379%2C1934.407z%22%2F%3E%0A%09%3Ctext%20transform%3D%22translate(729.546%20800)%22%20fill%3D%22%23fff%22%20style%3D%22font-weight%3Abold%3B%20text-align%3A%20center%3B%22%20font-size%3D%22480%22%20text-anchor%3D%22middle%22%3E' + label + '%3C%2Ftext%3E%0A%3C%2Fsvg%3E';
         */
        return 'data:image/svg+xml,' +
            //    '%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20version%3D%221.0%22%20id%3D%22Layer_1%22%20x%3D%220px%22%20y%3D%220px%22%20width%3D%2248%22%20height%3D%2248%22%20viewBox%3D%220%200%201710%202073%22%20enable-background%3D%22new%200%200%201710%202073%22%20xml%3Aspace%3D%22preserve%22%3E%0A%09%3Cpath%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%20fill%3D%22%23E81E25%22%20stroke%3D%22%23000000%22%20stroke-width%3D%2237%22%20stroke-miterlimit%3D%2210%22%20d%3D%22%20%20%20M730.94%2C1839.629c-38.766-190.301-107.116-348.665-189.903-495.44c-61.407-108.872-132.544-209.363-198.364-314.938%20%20%20c-21.972-35.244-40.934-72.477-62.047-109.054c-42.216-73.137-76.444-157.935-74.269-267.932%20%20%20c2.125-107.473%2C33.208-193.684%2C78.03-264.172c73.719-115.935%2C197.201-210.989%2C362.884-235.969%20%20%20c135.466-20.424%2C262.475%2C14.082%2C352.543%2C66.748c73.6%2C43.038%2C130.596%2C100.527%2C173.92%2C168.28%20%20%20c45.22%2C70.716%2C76.359%2C154.26%2C78.971%2C263.232c1.337%2C55.83-7.805%2C107.532-20.684%2C150.418%20%20%20c-13.034%2C43.409-33.996%2C79.695-52.646%2C118.454c-36.406%2C75.659-82.049%2C144.982-127.855%2C214.346%20%20%20C915.083%2C1340.208%2C787.024%2C1550.912%2C730.94%2C1839.629z%22%2F%3E%0A%09%0A%09%3Ctext%20transform%3D%22translate(729.546%20800)%22%20fill%3D%22%23fff%22%20style%3D%22font-weight%3Abold%3B%20text-align%3A%20center%3B%22%20font-size%3D%22480%22%20text-anchor%3D%22middle%22%3E' + label + '%3C%2Ftext%3E%0A%3C%2Fsvg%3E';
            '%3Csvg%20baseProfile%3D%22basic%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2236%22%20height%3D%2236%22%20viewBox%3D%220%200%2048%2048%22%3E%0A%20%20%20%20%3Cpath%20fill%3D%22%23F44336%22%20stroke%3D%22%23D32F2F%22%0A%20%20%20%20%20%20%20%20%20%20d%3D%22M24%200c-9.8%200-17.7%207.8-17.7%2017.4%200%2015.5%2017.7%2030.6%2017.7%2030.6s17.7-15.4%2017.7-30.6c0-9.6-7.9-17.4-17.7-17.4z%22%2F%3E%0A%20%20%20%20%3Ctext%20transform%3D%22translate(23.5%2024)%22%20fill%3D%22%23fff%22%20style%3D%22font-weight%3Abold%3B%20text-align%3A%20center%3B%22%20font-size%3D%2214%22%0A%20%20%20%20%20%20%20%20%20%20text-anchor%3D%22middle%22%3E' + label + '%3C%2Ftext%3E%0A%3C%2Fsvg%3E';
    },
    createMarker: function (latLng, store, translation, num) {
        var html = "<b>" + store.ShopName + "</b> <br/>" + store.DisplayedAddress.replace(/\r\n|\r|\n/g, "<br/>");

        var workingHours = "";
        for (i = 0; i < days.length; i++) {
            console.log(store[days[i]]);
            if (typeof store[days[i]] != 'undefined' && store[days[i]] != "") {
                workingHours += translation[days[i]] + ": " + store[days[i]] + "</br>";
            }
        }
        if (typeof workingHours != 'undefined') {
            html += "<br/><br/><b>" + translation.workingHours + "</b><br/>";
            html += workingHours;
        }
        var marker = new google.maps.Marker({
            position: latLng,
            map: map,
            icon: sdStoreLocator.getIcon(sdStoreLocator.getLabel(num))
        });
        google.maps.event.addListener(marker, 'click', function () {
            infoWindow.setContent(html);
            infoWindow.open(map, marker);
        });
        markers.push(marker);
    },
    createOption: function (ShopName, ShopAddress, distance, num, translation) {
        $(".sd-store-list").each(function () {
            var container = $(this).find(".list-group");
            var item = document.createElement("a");
            item.setAttribute("href", "#");
            item.setAttribute("data-id", num);
            item.className = "list-group-item location-item text-left";
            item.innerHTML = "<span class='col-xs-3'><img src='" + sdStoreLocator.getIcon(sdStoreLocator.getLabel(num)) + "' alt='' class='img-responsive'></span>" +
                "<span class='col-xs-9'>" +
                "<b>" + ShopName + "</b></br>" +
                "<small class='text-muted'>" + parseFloat(distance).toFixed(1) + translation.distanceStr +
                "</span>";
            container.append(item);
        })
    },
    doNothing: function () {
    },
    displayMessage: function (block) {

    },
    blocksManipulations: function () {
        var gMap = $("#g-map");
        var list = $(".sd-store-list.hidden-xs");
        //  var searchBlock = $("#sd-sl-search");
        var searchInput = $("#sd-enter-address");
        var searchBlock = searchInput.parent();
        var windowWidth = $(window).width();
        var height;
        console.log(searchBlock);
        if (windowWidth >= 992)
            searchInput.width(searchBlock.outerWidth(true) - searchBlock.find("label").outerWidth(true) - 70);
        else searchInput.css("width", "100%");
        if (windowWidth < 768) {
            list.css("height", "auto");
        }
        if (windowWidth < 640) {
            height = gMap.width();
            list.css("height", "auto");
        }
        else {
            height = gMap.width() * .5626;
            list.height(height);
        }
        gMap.height(height);
        // list.height(height);
    }
};
window.onload = function () {
    sdStoreLocator.init();
};
//]]>