{if $isError}
    <p class="alert alert-danger">{$errorMsg}</p>
{else}
    <div id="sd-store-locator">
        <div class="row" id="sd-sl-search">
            <div class="form-group col-xs-6 col-sm-4">
                <label for="sd-enter-address" style="width: 100%">
                    <input type="search" class="form-control" id="sd-enter-address"
                           placeholder="{$translation->enterAddress}"></label>
            </div>
            <div class="hidden-xs col-sm-1">
                <button type="button" id="sd-search-store" class="btn btn-primary pull-right"><i class="fa fa-search"
                                                                                                 aria-hidden="true"></i><span
                            class="hidden-sm"> {lang section="global" key="search"}</span></button>
            </div>
            <div class="col-xs-6 col-sm-3">
                <button type="button" class="btn btn-success pull-right"
                        onclick="sdStoreLocator.searchStores(false, 14)"
                        id="sd-search-near"><i class="fa fa-crosshairs" aria-hidden="true"></i><span
                            class="hidden-xs"> {$translation->findNearMe}</span>
                </button>
            </div>
            <div class="hidden-xs col-sm-5 col-md-4">
                <div class="pull-right btn-group" data-toggle="buttons">
                    <label class="btn btn-info active">
                        <input type="checkbox" autocomplete="off" id="showNormalStores" data-type-id="1"
                               onchange="sdStoreLocator.changeFilter(this)" checked
                               value="1"> {$translation->showNormalStores}
                    </label>
                    <label class="btn btn-info active">
                        <input type="checkbox" autocomplete="off" id="showOnlineStores" data-type-id="2"
                               onchange="sdStoreLocator.changeFilter(this)" checked
                               value="1"> {$translation->showOnlineStores}
                    </label>
                </div>
            </div>
        </div>
        <div>
            <ul class="nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#sd-map-view" aria-controls="home" role="tab"
                                                          data-toggle="tab">{$translation->mapView}</a>
                </li>
                <li role="presentation"><a href="#sd-list-view" aria-controls="profile" role="tab"
                                           data-toggle="tab">{$translation->listView}</a>
                </li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane fade in active" id="sd-map-view">
                    <div class="hidden-xs col-sm-5 col-md-4 pull-right sd-store-list"
                         style="margin-top: 25px">
                        <div class="list-group">
                            <i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>
                        </div>
                    </div>
                    <div id="g-map" class="col-xs-12 col-sm-7 col-md-8" style="margin-top: 25px"><i
                                class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></div>
                    <div class="visible-xs col-xs-12 sd-store-list"
                         style="margin-top: 25px">
                        <div class="list-group">
                            <i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="row tab-pane fade" id="sd-list-view"></div>
            </div>
        </div>
    </div>
    <script src="//maps.googleapis.com/maps/api/js?key={$settings->apiKey}&libraries=places&language={$langArray[$lang]}"
            type="text/javascript"></script>
    {nocache}
        <script>
            var sd_store_locator = {ldelim}
                url: "{$oPlugin->cFrontendPfadURLSSL}",
                radius: {$settings->radius},
                measure: {$settings->measure},
                defLat: '{$settings->defLat}',
                defLng: '{$settings->defLng}',
                address: '{$settings->address}',
                geolocationOff: '{$translation->geolocationOff}',
                lang: '{$lang}'
                {rdelim};
        </script>
    {/nocache}
    </div>
{/if}