//<![CDATA[
var map;
var markers = [];
var infoWindow;
var position;
var labels = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
var days = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];
var cookieName = "storeLocator";
var cookie;
var userMarker;
var searchMarker;
var timeoutHandle;
var oldLat, oldLng;

var sdStoreLocator = {
  init: function () {
    $(document).ready(function () {
      sdStoreLocator.blocksManipulations();
    });
    $(window).resize(function () {
      sdStoreLocator.blocksManipulations();
    });
    map = new google.maps.Map(document.getElementById("g-map"), {
      zoom: 12,
      maxZoom: 16,
      minZoom: 6,
      mapTypeId: 'roadmap'
    });

    sdStoreLocator.geoLocation();
    infoWindow = new google.maps.InfoWindow();
    sdStoreLocator.searchStores();
    var input = /** @type {!HTMLInputElement} */(
      document.getElementById('sd-enter-address'));
    var autocomplete = new google.maps.places.Autocomplete(input);
    autocomplete.bindTo('bounds', map);
    autocomplete.addListener('place_changed', function () {
      if (!$("#sd-map-view").is(":visible")) {
        $("a[href='#sd-map-view']").trigger("click");
        $("a[href='#sd-map-view']").on('shown.bs.tab', function (e) {
          google.maps.event.trigger(map, 'resize');
          sdStoreLocator.searchFromInput(autocomplete)
        })
      } else
        sdStoreLocator.searchFromInput(autocomplete);
    });
    $("#sd-search-store").on('click', function () {
      if (!$("#sd-map-view").is(":visible")) {
        $("a[href='#sd-map-view']").trigger("click");
        $("a[href='#sd-map-view']").on('shown.bs.tab', function (e) {
          google.maps.event.trigger(map, 'resize');
          sdStoreLocator.searchFromInput(autocomplete)
        })
      } else
        sdStoreLocator.searchFromInput(autocomplete);
    });
    google.maps.event.addListener(map, "dragend", function () {
      window.clearTimeout(timeoutHandle);
      timeoutHandle = window.setTimeout(function () {
        sdStoreLocator.changeCenter()
      }, 500);
    });
    google.maps.event.addListener(map, "zoom_changed", function () {
      window.clearTimeout(timeoutHandle);
      timeoutHandle = window.setTimeout(function () {
        sdStoreLocator.changeCenter()
      }, 500);
    });
  },
  searchFromInput: function (autocomplete) {
    if ($("#sd-enter-address").val() == "") {
      if (typeof searchMarker !== "undefined") searchMarker.setMap(null);
      return;
    }
    infoWindow.close();
    $("#sd-sl-search").find("button#sd-search-store>i").removeAttr("class").addClass("fa fa-circle-o-notch fa-spin fa-fw");
    var place = autocomplete.getPlace();
    if (!place.geometry) {
      // window.alert("Autocomplete's returned place contains no geometry");
      return;
    }
    if (place.geometry.viewport) {
      map.fitBounds(place.geometry.viewport);
    } else {
      map.setCenter(place.geometry.location);
      map.setZoom(12);  // Why 17? Because it looks good.
    }
    var address = '';
    if (place.address_components) {
      address = [
        (place.address_components[0] && place.address_components[0].short_name || ''),
        (place.address_components[1] && place.address_components[1].short_name || ''),
        (place.address_components[2] && place.address_components[2].short_name || '')
      ].join(' ');
    }

    if (typeof searchMarker !== "undefined") {
      searchMarker.setMap(null);
    }
    searchMarker = new google.maps.Marker({
      position: place.geometry.location,
      map: map,
      icon: sdStoreLocator.getIcon("", "2196F3")
    });

    sdStoreLocator.changeCenter(true);
  },
  geoLocation: function () {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(function (position) {
        map.setCenter(new google.maps.LatLng(position.coords.latitude, position.coords.longitude));
        oldLat = position.coords.latitude;
        oldLng = position.coords.longitude;
        userMarker = new google.maps.Marker({
          position: new google.maps.LatLng(position.coords.latitude, position.coords.longitude),
          map: map,
          icon: sdStoreLocator.getIcon("", "4CAF50")
        });
      }, function () {
        $("#sd-search-near").remove();
        sdStoreLocator.noGeoLocation();
      });
      console.log()
    } else {
      sdStoreLocator.noGeoLocation();
    }
  },
  noGeoLocation: function () {
    $(".sd-store-list").find("i").remove("i");
    var geocoder = new google.maps.Geocoder();
    geocoder.geocode({'address': sd_store_locator.address}, function (results, status) {
      if (status == google.maps.GeocoderStatus.OK) {
        map.setCenter(results[0].geometry.location);
        map.fitBounds(results[0].geometry.viewport);
        sdStoreLocator.searchLocations(results[0].geometry.location, true);
      } else {
        position = new google.maps.LatLng(sd_store_locator.defLat, sd_store_locator.defLng);
        map.setCenter(position);
        map.setZoom(6);
        sdStoreLocator.searchLocations(position, true);
      }
    });
  },
  searchStores: function (searchAll, zoom) {

    if ($("#sd-enter-address").val() != "") {
      $("#sd-enter-address").val("");
      if (typeof searchMarker !== "undefined") {
        searchMarker.setMap(null);
      }
    }
    searchAll = typeof searchAll !== 'undefined' ? searchAll : false;
    var geocoder = new google.maps.Geocoder();
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(function (position) {
        geocoder.geocode({location: new google.maps.LatLng(position.coords.latitude, position.coords.longitude)}, function (results, status) {
          if (status == google.maps.GeocoderStatus.OK) {
            sdStoreLocator.searchLocations(results[0].geometry.location, searchAll);
            map.setCenter(results[0].geometry.location);
            if (typeof zoom !== 'undefined') map.setZoom(zoom);
          } else {
            alert(address + ' not found');
          }
        });
      }, function () {
        sdStoreLocator.noGeoLocation();

      });
    }
    // Browser doesn't support Geolocation
    else {
      sdStoreLocator.noGeoLocation();
    }
  },
  searchLocations: function (center, searchAll, radius, userLat, userLng) {
    searchAll = typeof searchAll !== 'undefined' ? searchAll : false;
    var data;
    data = {
      lat: center.lat(),
      lng: center.lng(),
      measure: sd_store_locator.measure,
      language: sd_store_locator.lang,
      radius: 750,
      normalStores: ($("#showNormalStores").is(":checked")) ? 1 : 0,
      onlineStores: ($("#showOnlineStores").is(":checked")) ? 1 : 0
    };
    if (typeof userLat !== 'undefined') {
      data["userLat"] = userLat;
    }
    if (typeof userLng !== 'undefined') {
      data["userLng"] = userLng;
    }
    /*  if (!searchAll) {
     var defaultRadius = 5;
     data["radius"] = typeof radius !== 'undefined' ? radius : defaultRadius;
     }*/
    sdStoreLocator.setCookie(data);
    $.ajax({
      url: sd_store_locator.url + 'sd-store-locator.php',
      data: data,
      type: "POST",
      success: function (result, status, xhr) {
        var json = JSON.parse(xhr.responseText);
        if (typeof json.log != 'undefined') {
          console.log(json.log);
        }
        if (typeof json.error != 'undefined') {
          sdStoreLocator.clearLocations();
          $(".sd-store-list").find(".list-group").html("<p class='alert alert-warning'>" + json.error + "</p>");
          $("#sd-list-view").html("<div class='col-xs-12'><p class='alert alert-warning'>" + json.error + "</p></div>");
          $("#sd-sl-search").find("button.btn-primary>i").removeAttr("class").addClass("fa fa-search");
        } else {
          var bounds = new google.maps.LatLngBounds();
          var stores = json.stores;
          var physStore = 0;
          sdStoreLocator.clearLocations();
          var j = -1;
          for (var i = 0; i < stores.length; i++) {
            if (stores[i].StoreType == "1") j++;
            var StoreName = stores[i].StoreName;
            var distance = stores[i].distance;
            sdStoreLocator.createOption(StoreName, stores[i], distance, j, json.translation);
            if (stores[i].StoreType == "1") {
              physStore++;
              var latLng = new google.maps.LatLng(
                parseFloat(stores[i].Lat), parseFloat(stores[i].Lng));
              bounds.extend(latLng);
              sdStoreLocator.createMarker(latLng, stores[i], json.translation, j);
            }

          }

          // map.fitBounds(bounds);
          $("a[href='#sd-list-view']").on("shown.bs.tab", function () {
            //sdStoreLocator.listViewBlockHeight();
          });
          $("#sd-sl-search").find("button.btn-primary>i").removeAttr("class").addClass("fa fa-search");
          $(".location-item").on("click", function (event) {
            if ($(this).attr("data-store-type") == "2" || $(event.target).is("a")) return;
            event.preventDefault();
            var markerNum = parseInt($(this).attr("data-id"), 10);
            if (markerNum != "none") {
              new google.maps.event.trigger(markers[markerNum], 'click');
              var currCenter = map.getCenter();
              map.setZoom(16);
              google.maps.event.trigger(map, 'resize');
              map.setCenter(markers[markerNum].position);
              markers[markerNum].setMap(map);
            }
          });
        }
      },
      error: function (xhr, status, error) {
        var s = status;
      }
    });
  },
  clearLocations: function () {
    infoWindow.close();
    $(".sd-store-list").find(".list-group").html('');
    $("#sd-list-view").html('');
    if ($(".sd-store-list").find("p.alert").length > 0) $(".sd-store-list").html("<div class='list-group'></div>");
    for (var i = 0; i < markers.length; i++) {
      markers[i].setMap(null);
    }
    markers.length = 0;
  },
  getLabel: function (num) {
    var l = [], c, n = num;
    do {
      c = Math.floor(n / labels.length);
      if (c > 0) {
        l.push(labels[c - 1]);
        n = n - (labels.length * c);
      } else {
        l.push(labels[n]);
        n = -1;
      }
    }
    while (n >= 0);
    return l.join("");
  },
  getIconBorder: function (hex, lum) {

    // validate hex string
    hex = String(hex).replace(/[^0-9a-f]/gi, '');
    if (hex.length < 6) {
      hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2];
    }
    lum = lum || 0;

    // convert to decimal and change luminosity
    var rgb = "", c, i;
    for (i = 0; i < 3; i++) {
      c = parseInt(hex.substr(i * 2, 2), 16);
      c = Math.round(Math.min(Math.max(0, c + (c * lum)), 255)).toString(16);
      rgb += ("00" + c).substr(c.length);
    }

    return rgb;
  },
  getIcon: function (label, markerColor) {
    /*
     return 'data:image/svg+xml,' +
     '%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20version%3D%221.0%22%20id%3D%22Layer_1%22%20x%3D%220px%22%20y%3D%220px%22%20width%3D%2264px%22%20height%3D%2264px%22%20viewBox%3D%220%200%202481%202073%22%20enable-background%3D%22new%200%200%202481%202073%22%20xml%3Aspace%3D%22preserve%22%3E%0A%09%3Cpath%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%20fill%3D%22%23E81E25%22%20stroke%3D%22%23000000%22%20stroke-width%3D%2237%22%20stroke-miterlimit%3D%2210%22%20d%3D%22%20%20%20M730.94%2C1839.629c-38.766-190.301-107.116-348.665-189.903-495.44c-61.407-108.872-132.544-209.363-198.364-314.938%20%20%20c-21.972-35.244-40.934-72.477-62.047-109.054c-42.216-73.137-76.444-157.935-74.269-267.932%20%20%20c2.125-107.473%2C33.208-193.684%2C78.03-264.172c73.719-115.935%2C197.201-210.989%2C362.884-235.969%20%20%20c135.466-20.424%2C262.475%2C14.082%2C352.543%2C66.748c73.6%2C43.038%2C130.596%2C100.527%2C173.92%2C168.28%20%20%20c45.22%2C70.716%2C76.359%2C154.26%2C78.971%2C263.232c1.337%2C55.83-7.805%2C107.532-20.684%2C150.418%20%20%20c-13.034%2C43.409-33.996%2C79.695-52.646%2C118.454c-36.406%2C75.659-82.049%2C144.982-127.855%2C214.346%20%20%20C915.083%2C1340.208%2C787.024%2C1550.912%2C730.94%2C1839.629z%22%2F%3E%0A%09%3Cpath%20opacity%3D%220.09%22%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%20d%3D%22M731.379%2C1934.407%20%20%20c131.604-120.864%2C211.314-235.977%2C269.138-350.49c42.892-84.942%2C70.542-169.166%2C106.953-254.061%20%20%20c12.156-28.34%2C28.508-56.568%2C42.519-85.3c28.018-57.449%2C72.657-118.133%2C169.03-178.096c94.16-58.588%2C193.955-93.756%2C291.58-114.697%20%20%20c160.565-34.442%2C344.277-37.299%2C502.593%2C15.593c129.444%2C43.246%2C204.674%2C113.469%2C233.778%2C178.863%20%20%20c23.783%2C53.438%2C21.428%2C108.185-1.045%2C163.103c-23.455%2C57.32-69.568%2C116.065-161.105%2C177.391%20%20%20c-46.898%2C31.417-98.9%2C56.333-146.412%2C74.868c-48.088%2C18.761-96.6%2C30.392-145.328%2C44.32%20%20%20c-95.119%2C27.188-192.42%2C47.153-289.891%2C67.076C1312.866%2C1732.316%2C1025.938%2C1797.298%2C731.379%2C1934.407z%22%2F%3E%0A%09%3Ctext%20transform%3D%22translate(729.546%20800)%22%20fill%3D%22%23fff%22%20style%3D%22font-weight%3Abold%3B%20text-align%3A%20center%3B%22%20font-size%3D%22480%22%20text-anchor%3D%22middle%22%3E' + label + '%3C%2Ftext%3E%0A%3C%2Fsvg%3E';
     */
    if (typeof label === "undefined" || !label) label = "";
    if (typeof markerColor === "undefined") markerColor = "F44336";
    var markerBorder = sdStoreLocator.getIconBorder(markerColor, -0.5);
    return 'data:image/svg+xml,' +
      //    '%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20version%3D%221.0%22%20id%3D%22Layer_1%22%20x%3D%220px%22%20y%3D%220px%22%20width%3D%2248%22%20height%3D%2248%22%20viewBox%3D%220%200%201710%202073%22%20enable-background%3D%22new%200%200%201710%202073%22%20xml%3Aspace%3D%22preserve%22%3E%0A%09%3Cpath%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%20fill%3D%22%23E81E25%22%20stroke%3D%22%23000000%22%20stroke-width%3D%2237%22%20stroke-miterlimit%3D%2210%22%20d%3D%22%20%20%20M730.94%2C1839.629c-38.766-190.301-107.116-348.665-189.903-495.44c-61.407-108.872-132.544-209.363-198.364-314.938%20%20%20c-21.972-35.244-40.934-72.477-62.047-109.054c-42.216-73.137-76.444-157.935-74.269-267.932%20%20%20c2.125-107.473%2C33.208-193.684%2C78.03-264.172c73.719-115.935%2C197.201-210.989%2C362.884-235.969%20%20%20c135.466-20.424%2C262.475%2C14.082%2C352.543%2C66.748c73.6%2C43.038%2C130.596%2C100.527%2C173.92%2C168.28%20%20%20c45.22%2C70.716%2C76.359%2C154.26%2C78.971%2C263.232c1.337%2C55.83-7.805%2C107.532-20.684%2C150.418%20%20%20c-13.034%2C43.409-33.996%2C79.695-52.646%2C118.454c-36.406%2C75.659-82.049%2C144.982-127.855%2C214.346%20%20%20C915.083%2C1340.208%2C787.024%2C1550.912%2C730.94%2C1839.629z%22%2F%3E%0A%09%0A%09%3Ctext%20transform%3D%22translate(729.546%20800)%22%20fill%3D%22%23fff%22%20style%3D%22font-weight%3Abold%3B%20text-align%3A%20center%3B%22%20font-size%3D%22480%22%20text-anchor%3D%22middle%22%3E' + label + '%3C%2Ftext%3E%0A%3C%2Fsvg%3E';
      '%3Csvg%20baseProfile%3D%22basic%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2236%22%20height%3D%2236%22%20viewBox%3D%220%200%2048%2048%22%3E%0A%20%20%20%20%3Cpath%20fill%3D%22%23' + markerColor + '%22%20stroke%3D%22%23' + markerBorder + '%22%0A%20%20%20%20%20%20%20%20%20%20d%3D%22M24%200c-9.8%200-17.7%207.8-17.7%2017.4%200%2015.5%2017.7%2030.6%2017.7%2030.6s17.7-15.4%2017.7-30.6c0-9.6-7.9-17.4-17.7-17.4z%22%2F%3E%0A%20%20%20%20%3Ctext%20transform%3D%22translate(23.5%2024)%22%20fill%3D%22%23fff%22%20style%3D%22font-weight%3Abold%3B%20text-align%3A%20center%3B%22%20font-size%3D%2214%22%0A%20%20%20%20%20%20%20%20%20%20text-anchor%3D%22middle%22%3E' + label + '%3C%2Ftext%3E%0A%3C%2Fsvg%3E';
  },
  createMarker: function (latLng, store, translation, num) {
    var address = (store.DisplayedAddress.length > 0) ? store.DisplayedAddress : store.StoreAddress;
    var html = "<b>" + store.StoreName + "</b> <br/>" + address.replace(/(?:\r\n|\r|\n|\\r\\n|\\r|\\n)/g, "<br/>");

    var workingHours = "";
    for (var i = 0; i < days.length; i++) {
      if (typeof store[days[i]] != 'undefined' && store[days[i]] != "") {
        workingHours += translation[days[i]] + ": " + store[days[i]] + "</br>";
      }
    }
    if (typeof workingHours != 'undefined' && workingHours.length > 0) {
      html += "<br/><br/><b>" + translation.workingHours + "</b><br/>";
      html += workingHours;
    }
    var marker = new google.maps.Marker({
      position: latLng,
      map: map,
      icon: sdStoreLocator.getIcon(sdStoreLocator.getLabel(num))
    });
    google.maps.event.addListener(marker, 'click', function () {
      if (!$("#sd-map-view").is(":visible")) {
        $("a[href='#sd-map-view']").trigger("click");
        $("a[href='#sd-map-view']").on('shown.bs.tab', function (e) {
          google.maps.event.trigger(map, 'resize');
          infoWindow.setContent(html);
          infoWindow.open(map, marker);
          map.setCenter(marker.position);
          marker.setMap(map);
        });
      } else {

        infoWindow.setContent(html);
        infoWindow.open(map, marker);
        map.setCenter(marker.position);
        marker.setMap(map);
      }
    });
    markers.push(marker);
  },
  createOption: function (StoreName, store, distance, num, translation) {

    $(".sd-store-list").each(function () {
      var content;
      var container = $(this).find(".list-group");
      var item;
      if (store.StoreType == "1") {
        item = document.createElement("a");
        item.setAttribute("href", "#");
      } else {
        item = document.createElement("div");
      }
      item.setAttribute("data-id", num);
      item.setAttribute("data-store-type", store.StoreType);
      item.className = "list-group-item location-item text-left";
      content = "<div class='row'>";
      content += "<span class='col-xs-2'>";
      content += (store.StoreType == "1") ? "<img src='" + sdStoreLocator.getIcon(sdStoreLocator.getLabel(num)) + "' alt='' class='img-responsive'>" : "<i style='color: red' class='fa fa-globe fa-2x'></i>";
      content += "</span>" +
        "<span class='col-xs-9'>" +
        "<b>" + StoreName + "</b>";
      if (store.StoreType == "1") {
        content += " <small>(" + parseFloat(distance).toFixed(1) + translation.distanceStr + ")</small><br/>";
        content += "<small>" + store.DisplayedAddress + "</small>";
      } else if (store.StoreUrl.length > 0) {
        content += "<br/><small><a href='" + store.StoreUrl + "' target='_blank'>" + store.StoreUrl + "</a></small>";
      }
      content += "</span></div>";
      item.innerHTML = content;
      container.append(item);
    });

    var listViewItem = document.createElement("div");
    listViewItem.setAttribute("class", "col-xs-12 col-sm-4 col-md-3 location-item");
    listViewItem.setAttribute("data-store-type", store.StoreType);
    listViewItem.setAttribute("data-id", num);
    var listViewAddress = (store.DisplayedAddress.length > 0) ? store.DisplayedAddress.replace(/(?:\r\n|\r|\n|\\r\\n|\\r|\\n)/g, '<br />') : store.StoreAddress;
    var listViewItemContent = "<div class='thumbnail'>";
    if (store.StoreLogo.length > 0) listViewItemContent += "<img src='" + store.StoreLogo + "' alt='" + StoreName + "'>";
    listViewItemContent += "<div class='caption'><address><strong>" + StoreName + "</strong><br>";
    if (store.StoreUrl.length > 0) listViewItemContent += "<small><a href='" + store.StoreUrl + "' target='_blank'>" + store.StoreUrl + "</a></small><br>";
    if (store.StoreType != "2") listViewItemContent += "<span class='text-muted'><small>" + listViewAddress + "</small></span><br>";
    listViewItemContent += "</address>";
    if (store.Description.length > 0) {
      listViewItemContent += "<p>" + store.Description.replace(/(?:\r\n|\r|\n|\\r\\n|\\r|\\n)/g, '<br />') + "</p>";
    }
    var workingHours = "";
    for (var i = 0; i < days.length; i++) {
      if (typeof store[days[i]] != 'undefined' && store[days[i]] != "") {
        workingHours += translation[days[i]] + ": " + store[days[i]] + "<br/>";
      }
    }

    if (typeof workingHours != 'undefined' && workingHours.length > 0) {
      listViewItemContent += "<div><small><b>" + translation.workingHours + "</b><br>";
      listViewItemContent += workingHours;
      listViewItemContent += "</small></div>";
    }
    listViewItemContent += "</div>";
    listViewItemContent += "</div>";
    listViewItem.innerHTML = listViewItemContent;
    $("#sd-list-view").append(listViewItem);
  },
  doNothing: function () {
  },
  displayMessage: function (block) {

  },
  blocksManipulations: function () {
    var gMap = $("#g-map");
    var list = $(".sd-store-list.hidden-xs");
    var windowWidth = $(window).width();
    var height;
    if (windowWidth < 768) {
      list.css("height", "auto");
    }
    if (windowWidth < 640) {
      height = gMap.width();
      list.css("height", "auto");
    } else {
      height = gMap.width();
      list.height(height);
    }
    gMap.height(height);
  },
  getCookie: function () {
    var result = document.cookie.match(new RegExp(cookieName + '=([^;]+)'));
    result && (result = JSON.parse(result[1]));
    return result;
  },
  setCookie: function (value) {
    cookie = [cookieName, '=', JSON.stringify(value), '; domain=.', window.location.host.toString(), '; path=/;'].join('');
    document.cookie = cookie;
  },
  getDistance: function () {
    var bounds = map.getBounds();
    var center = bounds.getCenter();

// r = radius of the earth in statute miles
    var r = sd_store_locator.measure;

// Convert lat or lng from decimal degrees into radians (divide by 57.2958)
    var lat1 = center.lat() / 57.2958;
    var lon1 = center.lng() / 57.2958;
    var lat2 = oldLat / 57.2958;
    var lon2 = oldLng / 57.2958;

// distance = circle radius from center to Northeast corner of bounds
    var dis = r * Math.acos(Math.sin(lat1) * Math.sin(lat2) +
      Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1));
    return dis;
  },
  changeFilter: function (filter) {
    var typeId = $(filter).attr("data-type-id");
    var type = $(filter).attr("type");
    if (type == "checkbox") {
      if ($(filter).is(":checked"))
        $("[data-store-type=" + typeId + "]").show();
      else
        $("[data-store-type=" + typeId + "]").hide()
    } else sdStoreLocator.changeCenter(true);

  },
  changeCenter: function (force) {
    var userLat, userLng;
    var bounds = map.getBounds();
    var center = bounds.getCenter();
    if (sdStoreLocator.getDistance() < 500 && typeof force == "undefined" && !force) return;
    oldLat = center.lat();
    oldLng = center.lng();
    if ($("#sd-enter-address").val() != "") {
      var searchLat = searchMarker.position.lat();
      var searchLng = searchMarker.position.lng();
    }
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(function (position) {
        userLat = (typeof searchLat != "undefined") ? searchLat : position.coords.latitude;
        userLng = (typeof searchLng != "undefined") ? searchLng : position.coords.longitude;
        $(".sd-store-list").find(".list-group").html('<i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>');
        $("#sd-list-view").html('<p class="col-xs-12"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></p>');
        sdStoreLocator.searchLocations(center, true, false, userLat, userLng);
      }, function () {
        $("#sd-search-near").remove();
        if (typeof searchLat != "undefined") sdStoreLocator.searchLocations(center, true, false, searchLat, searchLng);
        else sdStoreLocator.searchLocations(center, true, false);
      });
    } else {
      if (typeof searchLat != "undefined") sdStoreLocator.searchLocations(center, true, false, searchLat, searchLng);
      else sdStoreLocator.searchLocations(center, true, false);
    }
  },
  listViewBlockHeight: function () {
    var block = $("#sd-list-view").find(".thumbnail");
    var height = 0;
    block.each(function () {
      if ($(this).height() > height) height = $(this).height();
    });
    block.height(height);
  }
};
window.onload = function () {
  if ($("#g-map").length > 0)
    sdStoreLocator.init();
};
//]]>
